function [poststats] = postregression(ivar,dvar)
%This little script calculate post logistic regression statistics.
%Synatax:   [poststats] = postregresssion(ivar,dvar);
%Input:     ivar = matrix of independent variable
%           dvar = matrix of dependent variable
%Output:    poststats.wilks = the wilks likelihood-ratio test
%           poststats.wilkschi = p value for the wilks test, based on
%               chi-square.

%initial regression with all independent variables
[b,dev,stats] = glmfit(ivar,dvar,'binomial','link','logit');

%calculate the wald statistic
se = stats.se;
wald = b.^2./se.^2; %calculate p value use chisquare: p = 1-chi2cdf(poststats.wald,1);
%odds
odds = exp(b);
%probabilities
[yhat,dylo,dyhi] = glmval(b,ivar,'logit',stats);
%calculate the naive fit without independent variables, or likelihood ratio
%statistc
n1 = sum(dvar);     %number of ones
n = size(dvar,1);     %number of observations
n0 = n-n1;          %number of zeros
g = -2*(n1*log(n1)+n0*log(n0)-n*log(n));    %naive fit
%the improvement in fit using all independent variables
G = g-dev;
%chi-squared test, degree of freedom = difference in # of parameters
%between the two models
p = 1-chi2cdf(G,size(ivar,2));
%now calculate the likelihood ratio, after removal each independent variable
for i = 1:size(ivar,2)
    ivar_tmp = ivar;
    ivar_tmp(:,i) = []; %remove a column
    [b_tmp,dev_tmp,stats_tmp] = glmfit(ivar_tmp,dvar,'binomial','link','logit');
    G_tmp(i,1) = dev_tmp-dev;
    p_tmp(i,1) = 1-chi2cdf(G_tmp(i),1);
end
%consolidate
G = vertcat(G,G_tmp);
p = vertcat(p,p_tmp);
%store away
poststats(1).wilks = G;
poststats(1).wilschi = p;
poststats(1).beta = b;
poststats(1).dev = dev;
poststats(1).stats = stats;
poststats(1).nullmodel = g;
poststats(1).wald = wald;
poststats(1).odds = odds;
poststats(1).prob = yhat;